# POS.com Default Claude

Streamlined Claude Code environment for POS.com development with optimized MCP servers, specialized agents, and built-in guardrails.

## Quick Start

```bash
# 1. Run deployment
./deploy.sh

# 2. Configure API keys
nano ~/.claude/poscom-env.sh

# 3. Reload environment
source ~/.claude/poscom-env.sh

# 4. Start Claude with Chief Agent
claude --agents ~/.claude/agents/poscom
```

## What's Included

### Optimized MCP Servers (7)

| Server | Purpose |
|--------|---------|
| memory | Knowledge graph storage |
| thinking | Chain-of-thought reasoning |
| github | Repository operations |
| postgres | Database queries |
| redis | Cache and sessions |
| fetch | Web fetching with images |
| playwright | Browser automation |

**Removed duplicates:** memory-bank, puppeteer, imageFetch, context7, firecrawl

### POS.com Agents (6)

| Agent | Role |
|-------|------|
| **chief-agent** | Orchestrator - manages teams, creates agents, drives to completion |
| odoo-developer | Odoo ERP customization |
| backend-developer | Python/FastAPI APIs |
| frontend-developer | React/Vue UIs |
| database-architect | PostgreSQL optimization |
| security-auditor | Security validation |
| test-automator | Testing and quality gates |

### Chief Agent Capabilities

The Chief Agent:
- **Asks clarifying questions** before starting work
- **Creates new agents dynamically** when needed expertise doesn't exist
- **Launches teams in parallel** for efficiency
- **Validates all work** with tests and security scans
- **Never stops** until the ultimate goal is achieved
- **Iterates on failures** until success

## Directory Structure

```
poscom-default-claude/
├── deploy.sh           # One-click deployment script
├── settings.json       # MCP server configuration
├── env.sh              # Environment variables template
├── README.md           # This file
└── agents/
    ├── CLAUDE.md       # Guardrails and rules
    ├── chief-agent.md  # Orchestrator
    ├── odoo-developer.md
    ├── backend-developer.md
    ├── frontend-developer.md
    ├── database-architect.md
    ├── security-auditor.md
    └── test-automator.md
```

## Configuration

### Required API Keys

Edit `~/.claude/poscom-env.sh`:

```bash
export ANTHROPIC_API_KEY="sk-ant-..."
export GITHUB_PERSONAL_ACCESS_TOKEN="ghp_..."
```

### Database Connections

```bash
export POSTGRES_CONNECTION="postgresql://user:pass@host/poscom"
export REDIS_CONNECTION="redis://localhost:6379"
```

### Odoo Integration

```bash
export ODOO_URL="http://localhost:8069"
export ODOO_DB="poscom"
export ODOO_API_KEY="..."
```

## Guardrails

Built-in protections:
- No credential commits
- Parameterized queries enforced
- Tests required before completion
- Security scans on sensitive code
- Blocked dangerous operations

## Usage Examples

### Start with Chief Agent
```bash
claude --agents ~/.claude/agents/poscom
```

### Ask Chief to build a feature
```
"Build a customer loyalty program with points, tiers, and redemption"
```

Chief will:
1. Ask clarifying questions
2. Create loyalty-program-expert agent if needed
3. Assemble backend + frontend + database team
4. Coordinate parallel development
5. Run tests and security scans
6. Iterate until everything passes

### Specific Agent
```bash
# Use Odoo developer directly
claude --agent odoo-developer
```

## Copying to New Server

```bash
# Option 1: Copy folder
scp -r poscom-default-claude user@newserver:~/

# Option 2: Git (if you push to repo)
git clone your-repo poscom-default-claude

# Then deploy
cd poscom-default-claude
./deploy.sh
```

## Customization

### Add New Agent

Create `agents/my-agent.md`:
```markdown
---
name: my-agent
description: What this agent does
tools: Read, Write, Edit, Bash
---

You are a specialist in...
```

### Modify MCP Servers

Edit `settings.json` to add/remove servers.

### Change Guardrails

Edit `agents/CLAUDE.md` for project rules.
