---
name: poscom-instructions
description: POSCOM Claude project instructions and orchestration guidelines
tools:
  - Read
  - Grep
  - Glob
---

# POS.com Claude Instructions

## CRITICAL: Always Start with Chief Agent

**For ANY non-trivial task, Claude MUST consult chief-agent FIRST.**

The Chief Agent is your orchestrator. It will:
1. Analyze the task requirements
2. Select the optimal team of specialist agents
3. Coordinate parallel execution
4. Ensure quality gates are met
5. Never stop until the goal is achieved

### When to Use Chief Agent
- Multi-step tasks
- Tasks requiring multiple skills (backend + frontend + testing)
- Complex features or implementations
- Any task you're unsure how to approach
- Project planning and architecture decisions

### How to Invoke
```
Use chief-agent to: [describe the task]
```

Chief will then spawn and orchestrate the right specialists.

---

## Mandatory Rules - All Agents Must Follow

### Before ANY Code Change
1. Understand full context - ask questions if unclear
2. Check existing tests pass before making changes
3. Use TodoWrite to track multi-step work

### During Development
1. **Never** commit secrets or credentials
2. **Always** use parameterized queries (no SQL injection)
3. **Always** validate user input
4. Write tests for new functionality
5. Follow existing code patterns

### Before Marking Complete
1. All tests pass
2. No security vulnerabilities (high/critical)
3. Code reviewed for changes > 20 lines
4. Documentation updated if public API changed

## Blocked Actions (Will Be Rejected)

```
- rm -rf /
- Storing credit card numbers
- Disabling SSL/TLS verification
- Committing .env files
- Hardcoding API keys
- eval() or exec() with user input
```

## Agent Hierarchy

```
Chief Agent (orchestrates all work)
│
├── Backend Team
│   ├── backend-developer
│   ├── database-architect
│   └── security-auditor
│
├── Frontend Team
│   ├── frontend-developer
│   └── test-automator
│
└── Odoo Team
    ├── odoo-developer
    └── database-architect
```

## Quality Gates

| Gate | Requirement | Enforcer |
|------|-------------|----------|
| Unit Tests | 100% pass | test-automator |
| Integration | 100% pass | test-automator |
| Security | No high/critical | security-auditor |
| Coverage | >= 80% on critical paths | test-automator |
| Review | Approved | chief-agent |

## Working with Chief Agent

When assigned a task by Chief Agent:
1. Confirm understanding of the task
2. Do the work completely
3. Run relevant tests
4. Report results with clear pass/fail
5. If blocked, explain what's needed

## POS-Specific Standards

### Payment Processing
- Use payment processor tokenization
- Never store CVV/CVC
- Log transaction IDs, not card data
- Implement idempotency keys

### Customer Data
- Encrypt PII at rest
- Mask sensitive data in logs
- Implement data retention policies
- GDPR/CCPA compliance

### Inventory
- Use optimistic locking
- Audit trail for all changes
- Real-time sync with POS terminals
